#include "DHT.h"                                    // Librairie pour les modules de mesure de température et d'humidité DHT11 et DHT22
#include "DS3231.h"                                 // Librairie pour le module horloge temps réel DS3231
#include <SPI.h>                                    // Librairie pour qu'Arduino puisse utiliser le bus SPI pour communiquer avec le module de carte SD
#include <SD.h>                                     // Librairie pour pouvoir écrire sur la carte mémoire SD

#define BrocheDHT 2                                 // La broche DATA du capteur de température et d'humidité est connectée à la broche 2 de l'Arduino
#define BrocheCS  4                                 // La broche CS du module de carte mémoire SD est connectée à la broche 4 de l'Arduino

//-------------------------------------------------------------------------------------------------------------------------------------------------------
DHT dht(BrocheDHT, DHT22);                          // Déclaration du capteur de température et d'humidité : type DHT22, broche = 2
File FichierDonnees;                                // Déclaration du fichier de données
RTClib Horloge;                                     // Déclaration de l'horloge               
int n = 1;                                          // Numéro de la mesure en cours
int T = 5;                                          // Intervalle de temps entre deux mesures (en secondes)
int NombreLignesFichier = 12;                       // Taille du fichier : nombre de lignes de données à enregistrer
//-------------------------------------------------------------------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------------------------------------------------------------------
void setup() {    // PROCEDURE D'INITIALISATION        Lancée une seule fois en début d'exécution
//-------------------------------------------------------------------------------------------------------------------------------------------------------
  Serial.begin(9600);
  dht.begin();                                      // Démarrer la communication avec le capteur de température et d'humidité
  pinMode(BrocheCS, OUTPUT);                        // La broche à laquelle est connectée le module de carte mémoire SD est définie comme une sortie
   if (!SD.begin(4)) {
    Serial.println("Erreur initialisation carte SD !");
    while (1);
  }
  Serial.println("Carte SD initialisee...");
  Wire.begin();                                     // Démarrer l'interface I2C pour qu'Arduino puisse communiquer avec le module d'horloge temps réel DS3231
} //-----------------------------------------------------------------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------------------------------------------------------------------
void loop() {     // PROCEDURE APPELEE EN BOUCLE    
//-------------------------------------------------------------------------------------------------------------------------------------------------------
  if (n > NombreLignesFichier) {                      // Si on a le nombre de données suffisantes
    // Serial.println("Enregistrement fini !");    
  }
  else                                                // Sinon  : on continue l'enregistrement des données
  {
    float Temperature = dht.readTemperature();        // Lire la valeur : TEMPERATURE (en degrés C)
    float Humidite = dht.readHumidity();              // Lire la valeur : HUMIDITE (en %)
    DateTime Aujourdhui = Horloge.now();              // Lire la valeur : DATE / HEURE courante

    Serial.println(Temperature);
    Serial.println(Humidite);
    
    FichierDonnees = SD.open("data.txt",FILE_WRITE)  ; 
    if (FichierDonnees) { 
      FichierDonnees.print(Aujourdhui.year(),DEC)    ;  
      FichierDonnees.print('/')                      ;  
      FichierDonnees.print(Aujourdhui.month(),DEC)   ;  
      FichierDonnees.print('/')                      ;
      FichierDonnees.print(Aujourdhui.day(),DEC)     ; 
      FichierDonnees.print(' ')                      ;
      FichierDonnees.print(Aujourdhui.hour(),DEC)    ; 
      FichierDonnees.print(':')                      ;  // Ecrire les données sur la carte SD
      FichierDonnees.print(Aujourdhui.minute(),DEC)  ; 
      FichierDonnees.print(':')                      ;
      FichierDonnees.print(Aujourdhui.second(),DEC)  ; 
      FichierDonnees.print("\t")                     ;
      FichierDonnees.print(Temperature)              ; 
      FichierDonnees.print("\t")                     ;
      FichierDonnees.println(Humidite)               ; 
      FichierDonnees.flush()                         ;
      FichierDonnees.close()                         ;  // Fermer le fichier de données
    }
    else {
        Serial.println("Erreur ouverture fichier");
    }
  }
  n=n+1;
  delay(1000*T);                                        // Attendre T secondes
}//-------------------------------------------------------------------------------------------------------------------------------------------------------
